<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Ticket #<?php echo e($venta->id); ?></title>
    <style>
        body { font-family: 'Courier New', Courier, monospace; width: 80mm; margin: 0 auto; padding: 10px; font-size: 10pt; line-height: 1.2; }
        .center { text-align: center; }
        .bold { font-weight: bold; }
        .line { border-bottom: 1px dashed #000; margin: 5px 0; }
        .items { width: 100%; border-collapse: collapse; }
        .items td { padding: 3px 0; }
        .total-box { margin-top: 10px; text-align: right; }
        @media print { body { width: 100%; margin: 0; padding: 0; } }
    </style>
</head>
<body onload="window.print()">
    <div class="center">
        <div class="bold" style="font-size: 14pt;">CHELYFARMA</div>
        <div>BOTICA Y SALUD</div>
        <div>RUC: 20600000000</div>
        <div>Calle Principal #123 - Ciudad</div>
        <div class="line"></div>
        <div class="bold"><?php echo e(strtoupper($venta->tipo_documento)); ?> DE VENTA</div>
        <div class="bold">N° <?php echo e(str_pad($venta->id, 8, '0', STR_PAD_LEFT)); ?></div>
        <div><?php echo e($venta->created_at->format('d/m/Y H:i')); ?></div>
        <div class="line"></div>
    </div>

    <table class="items">
        <thead>
            <tr class="bold">
                <td style="width: 10%;">CANT</td>
                <td>DESCRIPCIÓN</td>
                <td style="text-align: right; width: 25%;">SUBT.</td>
            </tr>
        </thead>
        <tbody>
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $venta->detalles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detalle): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td class="center"><?php echo e($detalle->cantidad); ?></td>
                <td><?php echo e($detalle->producto?->nombre); ?></td>
                <td style="text-align: right;"><?php echo e(number_format($detalle->subtotal, 2)); ?></td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </tbody>
    </table>

    <div class="line"></div>
    <div class="total-box">
        <?php
            $totalReal = $venta->detalles->sum('subtotal');
        ?>
        <div class="bold">TOTAL A PAGAR: S/. <?php echo e(number_format($totalReal > 0 ? $totalReal : $venta->total, 2)); ?></div>
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($venta->efectivo_recibido > 0): ?>
        <div>EFECTIVO: S/. <?php echo e(number_format($venta->efectivo_recibido, 2)); ?></div>
        <div>VUELTO: S/. <?php echo e(number_format(max(0, $venta->efectivo_recibido - ($totalReal > 0 ? $totalReal : $venta->total)), 2)); ?></div>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        <div>MÉTODO: <?php echo e(strtoupper($venta->tipo_pago)); ?></div>
    </div>

    <div class="line"></div>
    <div class="center">
        <div>Atendido por: <?php echo e($venta->usuario?->name); ?></div>
        <div style="margin-top: 10px;">¡GRACIAS POR SU COMPRA!</div>
        <div style="font-size: 8pt; margin-top: 5px;">Representación impresa de la <?php echo e(ucfirst($venta->tipo_documento)); ?></div>
    </div>
</body>
</html><?php /**PATH C:\laragon\www\chelyfarma\resources\views/reports/ticket.blade.php ENDPATH**/ ?>