<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Ticket #{{ $venta->id }}</title>
    <style>
        body { font-family: 'Courier New', Courier, monospace; width: 80mm; margin: 0 auto; padding: 10px; font-size: 10pt; line-height: 1.2; }
        .center { text-align: center; }
        .bold { font-weight: bold; }
        .line { border-bottom: 1px dashed #000; margin: 5px 0; }
        .items { width: 100%; border-collapse: collapse; }
        .items td { padding: 3px 0; }
        .total-box { margin-top: 10px; text-align: right; }
        @media print { body { width: 100%; margin: 0; padding: 0; } }
    </style>
</head>
<body onload="window.print()">
    <div class="center">
        <div class="bold" style="font-size: 14pt;">CHELYFARMA</div>
        <div>BOTICA Y SALUD</div>
        <div>RUC: 20600000000</div>
        <div>Calle Principal #123 - Ciudad</div>
        <div class="line"></div>
        <div class="bold">{{ strtoupper($venta->tipo_documento) }} DE VENTA</div>
        <div class="bold">N° {{ str_pad($venta->id, 8, '0', STR_PAD_LEFT) }}</div>
        <div>{{ $venta->created_at->format('d/m/Y H:i') }}</div>
        <div class="line"></div>
    </div>

    <table class="items">
        <thead>
            <tr class="bold">
                <td style="width: 10%;">CANT</td>
                <td>DESCRIPCIÓN</td>
                <td style="text-align: right; width: 25%;">SUBT.</td>
            </tr>
        </thead>
        <tbody>
            @foreach($venta->detalles as $detalle)
            <tr>
                <td class="center">{{ $detalle->cantidad }}</td>
                <td>{{ $detalle->producto?->nombre }}</td>
                <td style="text-align: right;">{{ number_format($detalle->subtotal, 2) }}</td>
            </tr>
            @endforeach
        </tbody>
    </table>

    <div class="line"></div>
    <div class="total-box">
        @php
            $totalReal = $venta->detalles->sum('subtotal');
        @endphp
        <div class="bold">TOTAL A PAGAR: S/. {{ number_format($totalReal > 0 ? $totalReal : $venta->total, 2) }}</div>
        @if($venta->efectivo_recibido > 0)
        <div>EFECTIVO: S/. {{ number_format($venta->efectivo_recibido, 2) }}</div>
        <div>VUELTO: S/. {{ number_format(max(0, $venta->efectivo_recibido - ($totalReal > 0 ? $totalReal : $venta->total)), 2) }}</div>
        @endif
        <div>MÉTODO: {{ strtoupper($venta->tipo_pago) }}</div>
    </div>

    <div class="line"></div>
    <div class="center">
        <div>Atendido por: {{ $venta->usuario?->name }}</div>
        <div style="margin-top: 10px;">¡GRACIAS POR SU COMPRA!</div>
        <div style="font-size: 8pt; margin-top: 5px;">Representación impresa de la {{ ucfirst($venta->tipo_documento) }}</div>
    </div>
</body>
</html>