<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>{{ $title }}</title>
    <style>
        body { font-family: sans-serif; font-size: 10pt; color: #333; margin: 20px; }
        .header { text-align: center; border-bottom: 2px solid #333; margin-bottom: 20px; padding-bottom: 10px; }
        .header h1 { margin: 0; font-size: 20pt; color: #000; }
        .header p { margin: 5px 0 0; font-size: 10pt; color: #666; }
        table { width: 100%; border-collapse: collapse; border: 1px solid #ddd; }
        th { background-color: #f3f4f6; color: #000; padding: 10px; border: 1px solid #ddd; text-align: left; }
        td { padding: 8px; border: 1px solid #ddd; }
        tr:nth-child(even) { background-color: #f9fafb; }
        .footer { margin-top: 30px; text-align: right; font-size: 8pt; color: #999; }
        @media print {
            .no-print { display: none; }
            body { margin: 0; }
        }
    </style>
</head>
<body onload="window.print()">
    <div class="header">
        <h1>CHELYFARMA</h1>
        <p style="font-weight: bold; color: #1e293b; font-size: 14pt;">{{ $title }}</p>
        <p>Fecha de generación: {{ now()->format('d/m/Y H:i') }}</p>
    </div>

    <div style="margin-bottom: 20px; display: flex; justify-content: space-between;">
        @foreach($summary as $label => $value)
            <div style="background: #f1f5f9; padding: 10px 20px; border-radius: 8px; border: 1px solid #e2e8f0;">
                <div style="font-size: 8pt; color: #64748b; text-transform: uppercase; font-weight: bold;">{{ $label }}</div>
                <div style="font-size: 12pt; font-weight: 800; color: #0f172a;">{{ $value }}</div>
            </div>
        @endforeach
    </div>
    
    <table>
        <thead>
            <tr>
                @foreach($columns as $col)
                    <th>{{ $col }}</th>
                @endforeach
            </tr>
        </thead>
        <tbody>
            @foreach($data as $row)
                <tr>
                    @foreach($row as $cell)
                        <td>{{ $cell }}</td>
                    @endforeach
                </tr>
            @endforeach
        </tbody>
    </table>

    <div class="footer">
        Este documento es un reporte oficial de Chelyfarma v1.0
    </div>
</body>
</html>