<?php
namespace Database\Seeders;
use App\Models\User;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;

class DatabaseSeeder extends Seeder {
    public function run(): void {
        $adminRole = Role::firstOrCreate(['name' => 'administrador']);
        Role::firstOrCreate(['name' => 'vendedor']);
        
        $user = User::updateOrCreate(
            ['email' => 'admin@chelyfarma.com'],
            ['name' => 'Admin ChelyFarma', 'password' => \Illuminate\Support\Facades\Hash::make('password')]
        );
        $user->assignRole($adminRole);
    }
}