<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('exports', function (Blueprint $table) {
            if (!Schema::hasColumn('exports', 'failed_rows')) {
                $table->unsignedInteger('failed_rows')->default(0)->after('successful_rows');
            }
            if (!Schema::hasColumn('exports', 'options')) {
                $table->json('options')->nullable()->after('file_path');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('exports', function (Blueprint $table) {
            $table->dropColumn(['failed_rows', 'options']);
        });
    }
};