<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
return new class extends Migration {
    public function up(): void {
        Schema::create("productos", function (Blueprint $table) {
            $table->id();
            $table->string("nombre");
            $table->string("codigo")->unique();
            $table->decimal("precio", 10, 2);
            $table->integer("stock")->default(0);
            $table->integer("stock_minimo")->default(5);
            $table->date("fecha_vencimiento")->nullable();
            $table->foreignId("categoria_id")->nullable()->constrained("categorias")->onDelete("set null");
            $table->timestamps();
        });
    }
    public function down(): void { Schema::dropIfExists("productos"); }
};