<?php
namespace App\Providers\Filament;
use Filament\Http\Middleware\Authenticate;
use Filament\Http\Middleware\DisableBladeIconComponents;
use Filament\Http\Middleware\DispatchServingFilamentEvent;
use Filament\Pages;
use Filament\Panel;
use Filament\PanelProvider;
use Filament\Support\Colors\Color;
use Filament\Widgets;
use Illuminate\Cookie\Middleware\AddQueuedCookiesToResponse;
use Illuminate\Cookie\Middleware\EncryptCookies;
use Illuminate\Foundation\Http\Middleware\VerifyCsrfToken;
use Illuminate\Routing\Middleware\SubstituteBindings;
use Illuminate\Session\Middleware\AuthenticateSession;
use Illuminate\Session\Middleware\StartSession;
use Illuminate\View\Middleware\ShareErrorsFromSession;
use Filament\Navigation\MenuItem;
use Filament\Support\Enums\MaxWidth;
use Illuminate\Support\HtmlString;
use Filament\Actions\Exports\Enums\ExportFormat;

class AdminPanelProvider extends PanelProvider {
    public function panel(Panel $panel): Panel {
        return $panel
            ->default()
            ->id('admin')
            ->path('admin')
            ->login()
            ->colors(['primary' => Color::Slate, 'gray' => Color::Slate])
            ->font('Plus Jakarta Sans', 'https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;600;700;800&display=swap')
            ->sidebarCollapsibleOnDesktop()
            ->sidebarWidth('15rem')
            ->maxContentWidth(MaxWidth::Full)
            ->renderHook('panels::head.end', fn (): string => new HtmlString('
                <style>
                    :root { --fi-border-radius-md: 0.5rem; --fi-border-radius-lg: 0.75rem; }
                    .fi-main { padding-top: 1rem !important; padding-bottom: 1rem !important; }
                    .fi-section { padding: 0.85rem !important; margin-bottom: 1rem !important; }
                    .fi-section-header { margin-bottom: 0.5rem !important; }
                    .fi-ta-table td, .fi-ta-table th { padding: 0.5rem 0.75rem !important; }
                    .fi-ta-header-cell { font-size: 0.65rem !important; letter-spacing: 0.05em !important; }
                    .fi-sidebar-item-label { font-size: 0.85rem !important; }
                    .fi-sidebar-group-label { font-size: 0.7rem !important; }
                    .fi-input-wrp { border-radius: 0.5rem !important; height: 2.25rem !important; }
                    .fi-input { font-size: 0.875rem !important; }
                    .fi-btn { height: 2.25rem !important; font-size: 0.8rem !important; }

                    @media print {
                        .fi-sidebar, .fi-topbar, .fi-ta-header, .fi-ta-pagination, .fi-ta-actions, 
                        .fi-btn, .fi-ta-selection-indicator, .fi-ta-header-toolbar, 
                        .fi-breadcrumbs, .fi-header-actions, .fi-sidebar-close-overlay {
                            display: none !important;
                        }
                        .fi-main { padding: 0 !important; margin: 0 !important; }
                        .fi-main-ctn { padding: 0 !important; margin: 0 !important; max-width: none !important; }
                        .fi-section { border: none !important; box-shadow: none !important; padding: 0 !important; }
                        table { width: 100% !important; border-collapse: collapse !important; border: 1px solid #000 !important; }
                        th, td { border: 1px solid #ddd !important; font-size: 10pt !important; color: #000 !important; }
                        th { background-color: #f3f4f6 !important; -webkit-print-color-adjust: exact; }
                        
                        body::before {
                            content: "CHELYFARMA - REPORTE DE SISTEMA";
                            display: block;
                            font-size: 18pt;
                            font-weight: bold;
                            text-align: center;
                            margin-bottom: 20px;
                            border-bottom: 2px solid #000;
                            padding-bottom: 10px;
                        }
                        
                        body::after {
                            content: "Fecha de impresión: " attr(data-date);
                            display: block;
                            font-size: 8pt;
                            text-align: right;
                            margin-top: 20px;
                        }
                    }
                </style>
                <script>
                    window.onbeforeprint = () => document.body.setAttribute("data-date", new Date().toLocaleString());
                </script>
            '))
            ->discoverResources(in: app_path('Filament/Resources'), for: 'App\\Filament\\Resources')
            ->discoverPages(in: app_path('Filament/Pages'), for: 'App\\Filament\\Pages')
            ->pages([\App\Filament\Admin\Pages\Dashboard::class])
            ->discoverWidgets(in: app_path('Filament/Widgets'), for: 'App\\Filament\\Widgets')
            ->widgets([
                \App\Filament\Admin\Widgets\StatsOverview::class, 
                \App\Filament\Admin\Widgets\SalesChart::class,
                \App\Filament\Admin\Widgets\StockCriticoWidget::class,
            ])
            ->middleware([EncryptCookies::class, AddQueuedCookiesToResponse::class, StartSession::class, AuthenticateSession::class, ShareErrorsFromSession::class, VerifyCsrfToken::class, SubstituteBindings::class, DisableBladeIconComponents::class, DispatchServingFilamentEvent::class])
            ->userMenuItems([
                'profile' => MenuItem::make()->label('Mi Perfil')->icon('heroicon-m-user-circle')->url(fn() => \App\Filament\Pages\MiPerfil::getUrl()),
                MenuItem::make()->label(fn () => "Rol: " . (auth()->user()->getRoleNames()->first() ?? "Usuario"))->icon("heroicon-o-shield-check")->url("#"),
            ])
            ->authMiddleware([Authenticate::class]);
    }
}