<?php
namespace App\Policies;
use App\Models\User;
use App\Models\Venta;
class VentaPolicy {
    public function viewAny(User $user): bool { return $user->hasPermissionTo('ver ventas'); }
    public function view(User $user, Venta $model): bool { return $user->hasPermissionTo('ver ventas'); }
    public function create(User $user): bool { return $user->hasPermissionTo('crear ventas'); }
    public function update(User $user, Venta $model): bool { return $user->hasPermissionTo('editar ventas'); }
    public function delete(User $user, Venta $model): bool { return $user->hasPermissionTo('eliminar ventas'); }
}