<?php
namespace App\Policies;
use App\Models\User;
use App\Models\Categoria;
class CategoriaPolicy {
    public function viewAny(User $user): bool { return $user->hasPermissionTo('ver categorias'); }
    public function view(User $user, Categoria $model): bool { return $user->hasPermissionTo('ver categorias'); }
    public function create(User $user): bool { return $user->hasPermissionTo('crear categorias'); }
    public function update(User $user, Categoria $model): bool { return $user->hasPermissionTo('editar categorias'); }
    public function delete(User $user, Categoria $model): bool { return $user->hasPermissionTo('eliminar categorias'); }
}