<?php
namespace App\Models;
use Filament\Models\Contracts\FilamentUser;
use Filament\Models\Contracts\HasName;
use Filament\Panel;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Spatie\Permission\Traits\HasRoles;

class User extends Authenticatable implements FilamentUser, HasName {
    use Notifiable, HasRoles;
    protected $fillable = ['name', 'email', 'password', 'empleado_id'];
    protected $hidden = ['password', 'remember_token'];
    protected $casts = ['email_verified_at' => 'datetime', 'password' => 'hashed'];

    public function canAccessPanel(Panel $panel): bool { return true; }

    public function getFilamentName(): string {
        return $this->name;
    }

    public function empleado() {
        return $this->belongsTo(Empleado::class);
    }
}