<?php
namespace App\Models;
use Illuminate\Database\Eloquent\Model;
class MovimientoStock extends Model {
    protected $table = 'movimientos_stock';
    protected $fillable = ['producto_id', 'user_id', 'tipo', 'cantidad', 'motivo'];

    protected static function booted()
    {
        static::created(function ($movimiento) {
            $producto = $movimiento->producto;
            if ($movimiento->tipo === 'entrada') {
                $producto->increment('stock', $movimiento->cantidad);
            } else {
                $producto->decrement('stock', $movimiento->cantidad);
            }
        });
    }

    public function producto() { return $this->belongsTo(Producto::class); }
    public function usuario() { return $this->belongsTo(User::class, 'user_id'); }
}