<?php
namespace App\Filament\Resources\VentaResource\Pages;
use App\Filament\Resources\VentaResource;
use Filament\Actions;
use Filament\Resources\Pages\ListRecords;
class ListVentas extends ListRecords {
    protected static string $resource = VentaResource::class;
    public function getTitle(): string { return 'Listado de Ventas'; }
    public function getBreadcrumb(): string { return 'Listado'; }
    protected function getHeaderActions(): array {
        return [
            \Filament\Actions\Action::make('excel')
                ->label('Excel')
                ->icon('heroicon-m-table-cells')
                ->color('success')
                ->url(fn() => route('report.excel', 'ventas')),
            \Filament\Actions\Action::make('pdf')
                ->label('PDF')
                ->icon('heroicon-m-document-text')
                ->color('danger')
                ->url(fn() => route('report.pdf', 'ventas'))
                ->openUrlInNewTab(),
            Actions\CreateAction::make()->label('Nuevo POS')
        ];
    }
}