<?php
namespace App\Filament\Resources;
use App\Filament\Resources\UserResource\Pages;
use App\Models\User;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Filament\Forms\Components\{TextInput, Select};
use Filament\Tables\Columns\TextColumn;

class UserResource extends Resource {
    protected static ?string $model = User::class;
    protected static ?string $navigationIcon = 'heroicon-o-key';
    protected static ?string $navigationLabel = 'Accesos';
    protected static ?string $navigationGroup = 'Seguridad';

    public static function form(Form $form): Form {
        return $form->schema([
            TextInput::make('name')->required()->label('Nombre'),
            TextInput::make('email')->email()->required()->label('Correo'),
            Select::make('roles')->multiple()->relationship('roles', 'name')->preload()->label('Roles'),
            Select::make('empleado_id')->relationship('empleado', 'nombres')->label('Empleado'),
            TextInput::make('password')->password()->dehydrated(fn ($state) => filled($state))->required(fn (string $context): bool => $context === 'create')->label('Contraseña'),
        ]);
    }

    public static function table(Table $table): Table {
        return $table->columns([
            TextColumn::make('name')->label('Nombre'),
            TextColumn::make('email')->label('Correo'),
            TextColumn::make('roles.name')->badge()->label('Roles'),
            TextColumn::make('empleado.nombres')->label('Empleado'),
        ])->actions([Tables\Actions\EditAction::make(), Tables\Actions\DeleteAction::make()]);
    }

    public static function getPages(): array {
        return ['index' => Pages\ListUsers::route('/'), 'create' => Pages\CreateUser::route('/create'), 'edit' => Pages\EditUser::route('/{record}/edit')];
    }
}