<?php
namespace App\Filament\Resources\MovimientoStockResource\Pages;
use App\Filament\Resources\MovimientoStockResource;
use Filament\Resources\Pages\ListRecords;
class ListMovimientoStocks extends ListRecords {
    protected static string $resource = MovimientoStockResource::class;
    public function getTitle(): string { return 'Historial de Movimientos (Kardex)'; }

    protected function getHeaderActions(): array
    {
        return [
            \Filament\Actions\Action::make('excel')
                ->label('Excel')
                ->icon('heroicon-m-table-cells')
                ->color('success')
                ->url(fn() => route('report.excel', 'kardex')),
            \Filament\Actions\Action::make('pdf')
                ->label('PDF')
                ->icon('heroicon-m-document-text')
                ->color('danger')
                ->url(fn() => route('report.pdf', 'kardex'))
                ->openUrlInNewTab(),
            \Filament\Actions\CreateAction::make()->label('Registrar Lote'),
        ];
    }
}