<?php
namespace App\Filament\Pages;
use Filament\Forms\Components\Section;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Form;
use Filament\Pages\Page;
use Filament\Actions\Action;
use Filament\Notifications\Notification;
use Illuminate\Support\Facades\Hash;
use Illuminate\Validation\Rules\Password;
use Filament\Forms\Concerns\InteractsWithForms;
use Filament\Actions\Concerns\InteractsWithActions;
use Filament\Actions\Contracts\HasActions;
use Filament\Forms\Contracts\HasForms;

class MiPerfil extends Page implements HasForms, HasActions {
    use InteractsWithForms;
    use InteractsWithActions;
    protected static ?string $navigationIcon = 'heroicon-o-user-circle';
    protected static ?string $navigationLabel = 'Mi Perfil';
    protected static ?string $title = 'Gestionar Mi Cuenta';
    protected static ?string $slug = 'mi-perfil';
    protected static bool $shouldRegisterNavigation = false;
    protected static string $view = 'filament.pages.mi-perfil';
    public ?array $data = [];

    public function mount(): void {
        $this->form->fill(auth()->user()->attributesToArray());
    }

    public function form(Form $form): Form {
        return $form->schema([
            Section::make('Información Personal')->schema([
                TextInput::make('name')->label('Nombre Completo')->required(),
                TextInput::make('email')->label('Correo Electrónico')->email()->required()->unique('users', 'email', ignorable: auth()->user()),
            ])->columns(2),
            Section::make('Actualizar Contraseña')->schema([
                TextInput::make('current_password')->label('Contraseña Actual')->password()->currentPassword(),
                TextInput::make('new_password')->label('Nueva Contraseña')->password()->rule(Password::default()),
                TextInput::make('new_password_confirmation')->label('Confirmar Nueva Contraseña')->password()->same('new_password'),
            ])->columns(3),
        ])->statePath('data');
    }

    public function updateAction(): Action {
        return Action::make('update')->label('Guardar Cambios')->submit('form')->color('primary');
    }

    public function update(): void {
        $data = $this->form->getState();
        $user = auth()->user();
        $updateData = ['name' => $data['name'], 'email' => $data['email']];
        if (!empty($data['new_password'])) {
            $updateData['password'] = Hash::make($data['new_password']);
        }
        $user->update($updateData);
        if (!empty($data['new_password'])) {
            $this->data['current_password'] = null;
            $this->data['new_password'] = null;
            $this->data['new_password_confirmation'] = null;
        }
        Notification::make()->title('Perfil Actualizado')->success()->send();
    }
}