<?php

namespace App\Filament\Exports;

use App\Models\Producto;
use Filament\Actions\Exports\ExportColumn;
use Filament\Actions\Exports\Exporter;
use Filament\Actions\Exports\Models\Export;

class ProductoExporter extends Exporter
{
    protected static ?string $model = Producto::class;

    public function getFileDisk(): string
    {
        return 'public';
    }

    public static function getColumns(): array
    {
        return [
            ExportColumn::make('codigo')->label('Código'),
            ExportColumn::make('nombre')->label('Producto'),
            ExportColumn::make('categoria.nombre')->label('Categoría'),
            ExportColumn::make('stock')->label('Stock Actual'),
            ExportColumn::make('stock_minimo')->label('Stock Mínimo'),
            ExportColumn::make('precio')->label('Precio (S/.)'),
            ExportColumn::make('fecha_vencimiento')->label('Vencimiento'),
        ];
    }

    public static function getCompletedNotificationBody(Export $export): string
    {
        return 'La exportación de inventario ha sido completada.';
    }
}