<?php

namespace App\Filament\Exports;

use App\Models\MovimientoStock;
use Filament\Actions\Exports\ExportColumn;
use Filament\Actions\Exports\Exporter;
use Filament\Actions\Exports\Models\Export;

class MovimientoStockExporter extends Exporter
{
    protected static ?string $model = MovimientoStock::class;

    public function getFileDisk(): string
    {
        return 'public';
    }

    public static function getColumns(): array
    {
        return [
            ExportColumn::make('id')->label('ID'),
            ExportColumn::make('created_at')->label('Fecha'),
            ExportColumn::make('producto.nombre')->label('Producto'),
            ExportColumn::make('tipo')->label('Operación'),
            ExportColumn::make('cantidad')->label('Cantidad'),
            ExportColumn::make('motivo')->label('Motivo'),
            ExportColumn::make('usuario.name')->label('Registrado por'),
        ];
    }

    public static function getCompletedNotificationBody(Export $export): string
    {
        return 'La exportación del Kardex ha sido completada.';
    }
}