<?php

namespace App\Filament\Admin\Widgets;

use App\Models\User;
use App\Models\Venta;
use Filament\Tables;
use Filament\Tables\Table;
use Filament\Widgets\TableWidget as BaseWidget;
use Filament\Widgets\Concerns\InteractsWithPageFilters;
use Illuminate\Database\Eloquent\Builder;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;

class UserPerformanceWidget extends BaseWidget
{
    use InteractsWithPageFilters;

    protected static ?string $heading = 'Desempeño de Ventas por Usuario';
    protected static ?int $sort = 4;
    protected int | string | array $columnSpan = 'full';

    public function table(Table $table): Table
    {
        $desde = $this->filters['desde'] ?? now()->subDays(30)->format('Y-m-d');
        $hasta = $this->filters['hasta'] ?? now()->format('Y-m-d');
        $productoId = $this->filters['producto_id'] ?? null;
        $hoy = Carbon::today()->format('Y-m-d');

        return $table
            ->query(User::query())
            ->columns([
                Tables\Columns\TextColumn::make('name')->label('USUARIO')->weight('bold'),
                
                Tables\Columns\TextColumn::make('ventas_hoy')
                    ->label('VENTAS HOY')
                    ->getStateUsing(function (User $record) use ($hoy, $productoId) {
                        $query = DB::table('ventas')->where('user_id', $record->id)->whereDate('created_at', $hoy);
                        if ($productoId) {
                            $query->join('detalles_ventas', 'ventas.id', '=', 'detalles_ventas.venta_id')
                                  ->where('detalles_ventas.producto_id', $productoId);
                            $sumField = 'detalles_ventas.subtotal';
                        } else {
                            $sumField = 'ventas.total';
                        }
                        return 'S/. ' . number_format($query->sum($sumField), 2);
                    })->badge()->color('success'),

                Tables\Columns\TextColumn::make('ventas_periodo')
                    ->label('VENTAS PERIODO')
                    ->getStateUsing(function (User $record) use ($desde, $hasta, $productoId) {
                        $query = DB::table('ventas')->where('user_id', $record->id)
                                   ->whereDate('created_at', '>=', $desde)
                                   ->whereDate('created_at', '<=', $hasta);
                        if ($productoId) {
                            $query->join('detalles_ventas', 'ventas.id', '=', 'detalles_ventas.venta_id')
                                  ->where('detalles_ventas.producto_id', $productoId);
                            $sumField = 'detalles_ventas.subtotal';
                        } else {
                            $sumField = 'ventas.total';
                        }
                        return 'S/. ' . number_format($query->sum($sumField), 2);
                    })->badge()->color('info'),
            ])
            ->paginated(false);
    }
}