<?php

namespace App\Filament\Admin\Widgets;

use App\Models\Producto;
use App\Filament\Resources\ProductoResource;
use Filament\Tables;
use Filament\Tables\Table;
use Filament\Widgets\TableWidget as BaseWidget;
use Filament\Tables\Columns\TextColumn;

class StockCriticoWidget extends BaseWidget
{
    protected static ?int $sort = 3;
    protected static ?string $heading = '⚠️ Alerta de Stock Crítico';
    protected int | string | array $columnSpan = 'full';

    public function table(Table $table): Table
    {
        return $table
            ->query(
                Producto::whereColumn('stock', '<=', 'stock_minimo')
            )
            ->columns([
                TextColumn::make('nombre')
                    ->label('Producto')
                    ->searchable(),
                TextColumn::make('stock')
                    ->label('Actual')
                    ->badge()
                    ->color('danger'),
                TextColumn::make('stock_minimo')
                    ->label('Mínimo'),
                TextColumn::make('categoria.nombre')
                    ->label('Categoría'),
            ])
            ->actions([
                Tables\Actions\Action::make('reabastecer')
                    ->label('Ver Producto')
                    ->url(fn (Producto $record): string => ProductoResource::getUrl('edit', ['record' => $record]))
                    ->icon('heroicon-m-eye')
                    ->button(),
            ]);
    }
}