<?php

namespace App\Filament\Admin\Pages;

use Filament\Pages\Dashboard as BaseDashboard;
use Filament\Forms\Components\DatePicker;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\Section;
use Filament\Forms\Form;
use App\Models\Producto;
use App\Models\User;

class Dashboard extends BaseDashboard
{
    use BaseDashboard\Concerns\HasFiltersForm;
    public function getTitle(): string { return 'Panel de Análisis'; }

    public function filtersForm(Form $form): Form
    {
        return $form
            ->schema([
                Section::make('Filtros de Análisis')
                    ->schema([
                        DatePicker::make('desde')
                            ->label('Fecha Inicio')
                            ->default(now()->subDays(30)),
                        DatePicker::make('hasta')
                            ->label('Fecha Fin')
                            ->default(now()),
                        Select::make('producto_id')
                            ->label('Filtrar por Producto')
                            ->placeholder('Todos los productos')
                            ->options(Producto::pluck('nombre', 'id'))
                            ->searchable(),
                        Select::make('user_id')
                            ->label('Filtrar por Vendedor')
                            ->placeholder('Todos los vendedores')
                            ->options(User::pluck('name', 'id'))
                            ->searchable(),
                    ])
                    ->columns(4),
            ]);
    }
}